<?php
/**
 * Rule:
 *  - Chặn IP : $ip_max_visit / $ip_duration_time seconds
 *  - Thời gian chặn IP : $ip_penalty seconds
 *  
 *  - Chặn session: $session_max_visit / $sess_duration_time seconds
 *  - Thời gian chặn Session: $sess_duration_time seconds
 */

//Thư mục chứa địa chỉ IP được phép / bị cấm truy cập
$allowed_ip = 'ip_dos' . DIRECTORY_SEPARATOR . 'allowed' . DIRECTORY_SEPARATOR;
$banned_ip 	= 'ip_dos' . DIRECTORY_SEPARATOR . 'banned' . DIRECTORY_SEPARATOR;

// Khoảng thời gian để tính request là có phải hiện tượng Dos hay không !
$ip_duration_time 	= 150;
$sess_duration_time = 150;

// Số lần request được phép trên thời gian là $duration_time , tính theo giây
$ip_max_visit = 200;
$session_max_visit = 200;

// Thời gian chờ để được phép Request lại , tính theo giây
$ip_penalty = 300;
$session_penalty = 300;

// Thời gian hiện tại
$time = time();

// Uri hiện tại
$uri = $_SERVER['REQUEST_URI'];

// IP hiện tại
$ip = ip_address();

// Đánh dấu check Dos
$check_dos = true;

// Bỏ check dos với 1 url nhất định nào đó, ví dụ :
if (substr($uri,0,11) == '/uncheckdos'){
	$check_dos = false;
}

// Nếu IP không nằm trong thư mục cho phép thì tiến hành kiểm tra :
if ($check_dos && !file_exists($allowed_ip . $ip)){ 
	/*
	 * 1 . Check theo IP
	 */
	
	// Nếu tồn tại file trong thư mục bị chặn
	if (file_exists($banned_ip . $ip)){
		// Nếu thời gian từ lúc được ghi vào + $ip_penalty time lớn hơn hiện tại , tiến hành trả về lỗi 503
		if (filemtime($banned_ip . $ip) + $ip_penalty > $time){
			header("HTTP/1.0 503 Service Temporarily Unavailable");
			header("Connection: close");
			header("Content-Type: text/html");
            ?>
                <html>
                    <body>
                        <h1 style="color: #FF0000;">503 Service Temporarily Unavailable</h1>
                        <h2 style="color: #008000;">Wait <?php echo $ip_penalty; ?> seconds and try again...</h2>
                        <h3 style="color: #0000FF;">Wait <?php echo $ip_penalty; ?> seconds and try again...</h3>
                        <h4 style="color: #0000FF;">Wait <?php echo $ip_penalty; ?> seconds and try again...</h4>
                        <h5 style="color: #FF00FF;">Wait <?php echo $ip_penalty; ?> seconds and try again...</h5>
                    </body>
                </html>
            <?php
			//echo "<html><body><h1>503 Service Temporarily Unavailable</h1><h2>Wait $ip_penalty seconds and try again...</h2></body></html>";
			die();
		// Nếu không thì xóa file ghi tên địa chỉ IP bị cấm
		}else{
			unlink($banned_ip . $ip);
		}
	}
	
	// Thông tin kết nối cơ sở dữ liệu
	$conn = @mysql_connect(HOSTNAME,USERNAME,PASSWORD,TRUE);
	@mysql_select_db(DATABASE_1_NAME, $conn);

	// Đếm địa chỉ IP có thời gian request từ $ip_duration_time giây trở lại đây
	$sql = "select count(ip) from dos_ip where ip = '" . $ip . "' and requested_on > $time - $ip_duration_time";
	$no_req = @mysql_result(@mysql_query($sql, $conn), 0);
	
	
	// Nếu số bản ghi đếm được bằng số lượt visit tối đa , tiến hành cho vào thư mục IP bị cấm
    if ($no_req == $ip_max_visit - 1){
		touch($banned_ip . $ip);
	}
	// Ghi vào bảng default_dos_ip
	@mysql_query("insert into dos_ip(ip, requested_on, request_uri) values('$ip', $time,'$uri')");
	
	
	/**
	 * 2 . Check theo session
	 */
	
	// Kiểm tra số lần request của session
	$PHPSESSID = isset($_COOKIE['PHPSESSID']) ? $_COOKIE['PHPSESSID'] : '';
	if ($PHPSESSID != ''){
		// Đếm địa chỉ Session Id có thời gian request từ $session_penalty giây trở lại đây
		$sql = "select count(session_id) from dos_session where session_id = '" . $PHPSESSID . "' and requested_on > $time - $session_penalty";
		$no_req = @mysql_result(@mysql_query($sql, $conn), 0);
		// Nếu số đếm được bằng $session_max_visit , tiến hành trả về lỗi 503 và ngắt kết nối
		if ($no_req == $session_max_visit - 1){
			header("HTTP/1.0 503 Service Temporarily Unavailable");
			header("Connection: close");
			header("Content-Type: text/html");
			echo "<html><body><h1>503 Service Temporarily Unavailable</h1><h2>Wait $session_penalty seconds and try again...</h2></body></html>";
			die();
		}
		@mysql_query("insert into dos_session(session_id, requested_on,request_uri) values('$PHPSESSID', $time,'$uri')");
	}
	
	/**
	 * Ngắt kết nối
	 */
	@mysql_close($conn);
}

/**
 * Get IP Address
 * @return IP Address
 */
function ip_address()
{
	if ($_SERVER['REMOTE_ADDR'] && isset($_SERVER['HTTP_CLIENT_IP']))
	{
		return $_SERVER['HTTP_CLIENT_IP'];
	}
	elseif ($_SERVER['REMOTE_ADDR'])
	{
		return $_SERVER['REMOTE_ADDR'];
	}
	elseif ($_SERVER['HTTP_CLIENT_IP'])
	{
		return $_SERVER['HTTP_CLIENT_IP'];
	}
	elseif ($_SERVER['HTTP_X_FORWARDED_FOR'])
	{
		return $_SERVER['HTTP_X_FORWARDED_FOR'];
	}
}